/****** Object:  StoredProcedure [dbo].[usp_Get_Movement_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Movement_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Movement_Event]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		silvicap	
-- Create date: 24.10.2012
-- Description:	Get movement event by ID.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Movement_Event] 
	@ID	INT = NULL,
	@DOMAIN_ID NVARCHAR(50) = NULL
AS
BEGIN
SET NOCOUNT ON

	SELECT
		[ME].[ID],
		[ME].[ENTERED_DATE],
		[ME].[DOMAIN_ID],
		[ME].[IEN],
		[ME].[PATIENT_UID],
		[ME].[WARD_UID],
		[ME].[BED_UID],
		[ME].[OLD_WARD_UID],
		[ME].[OLD_BED_UID],
		[ME].[VISTA_SITE_UID],
		[TOM].[CODE] AS [TYPE_OF_MOVEMENT_CODE],
		[TOM].[CODE_SYSTEM] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM],
		[TOM].[CODE_SYSTEM_NAME] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME],
		[TOM].[DISPLAY_NAME] AS [TYPE_OF_MOVEMENT_DISPLAY_NAME],
		[ME].[MOVEMENT_DATE],
		[ME].[ENTERED_BY_UID],
		[ME].[ADMISSION_ID]
	FROM MOVEMENT_EVN AS ME
	LEFT JOIN CONCEPT AS TOM ON ME.TYPE_OF_MOVEMENT_ID = TOM.ID						
	WHERE [ME].[ID] = @ID AND [ME].[DOMAIN_ID] = @DOMAIN_ID

END
GO
